(function(CLIENT, $, undefined) {

    // Params cache
    CLIENT.params = {
        orig: {},
        local: {}
    };

    // App configuration
    CLIENT.config = {};
    CLIENT.config.app_id = 'streaming_manager';
    CLIENT.config.server_ip = ''; // Leave empty on production, it is used for testing only
    CLIENT.config.search = "?type=run" //location.search
    CLIENT.config.start_app_url = (CLIENT.config.server_ip.length ? 'http://' + CLIENT.config.server_ip : '') + '/bazaar?start=' + CLIENT.config.app_id + CLIENT.config.search;
    CLIENT.config.stop_app_url = (CLIENT.config.server_ip.length ? 'http://' + CLIENT.config.server_ip : '') + '/bazaar?stop=' + CLIENT.config.app_id;
    CLIENT.config.socket_url = 'ws://' + (CLIENT.config.server_ip.length ? CLIENT.config.server_ip : window.location.hostname) + '/wss'; // WebSocket server URI
    CLIENT.config.debug = true
    CLIENT.client_id = undefined;
    CLIENT.ping = undefined;
    CLIENT.nginx_live = false;
    CLIENT.nginx_live_timer = undefined;


    // App state
    CLIENT.state = {
        socket_opened: false
    };

    // Parameters cache
    CLIENT.parametersCache = {};

    // Other global variables
    CLIENT.ws = null;
    CLIENT.unexpectedClose = false;

    CLIENT.parameterStack = [];
    CLIENT.signalStack = [];

    CLIENT.client_log = function(...args) {
        if (CLIENT.config.debug){
            const d = new Date();
            console.log("LOG:CLIENT.js",d.getHours() + ":" + d.getMinutes() + ":"+ d.getSeconds() + ":" + d.getMilliseconds() ,...args);
        }
        }

    CLIENT.startApp = function() {
        $.get(
            CLIENT.config.start_app_url
            )
            .done(function(dresult) {
                if (dresult.status == 'OK') {
                    try {
                        CLIENT.connectWebSocket();
                        RP_CLIENT.connectWebSocket();
                    } catch (e) {
                        setTimeout(CLIENT.startApp, 2000);
                    }
                } else if (dresult.status == 'ERROR') {
                    console.log(dresult.reason ? dresult.reason : 'Could not start the application (ERR1)');
                    setTimeout(CLIENT.startApp, 2000);
                } else {
                    console.log('Could not start the application (ERR2)');
                    setTimeout(CLIENT.startApp, 2000);
                }
            })
            .fail(function() {
                console.log('Could not start the application (ERR3)');
                setTimeout(CLIENT.startApp, 2000);
            });
    };

    // Creates a WebSocket connection with the web server
    CLIENT.connectWebSocket = function() {
        let binParser = new BinarySignalParser();
        if (window.WebSocket) {
            CLIENT.ws = new WebSocket(CLIENT.config.socket_url);
            CLIENT.ws.binaryType = "arraybuffer";
        } else if (window.MozWebSocket) {
            CLIENT.ws = new MozWebSocket(CLIENT.config.socket_url);
            CLIENT.ws.binaryType = "arraybuffer";
        } else {
            console.log('Browser does not support WebSocket');
        }

        // Define WebSocket event listeners
        if (CLIENT.ws) {
            CLIENT.ws.onopen = function() {
                CLIENT.client_log('Socket opened');
                SM.GetIP();

                CLIENT.state.socket_opened = true;
                CLIENT.parametersCache = {}; // Remove all changed parameters via UI
                CLIENT.requestParameters();

                //setTimeout(showLicenseDialog, 2500);
                CLIENT.unexpectedClose = true;
                SM.getClients();
                SM.refreshFiles();
                $('#main').removeAttr("style");
            };

            CLIENT.ws.onclose = function() {
                CLIENT.state.socket_opened = false;
                CLIENT.client_log('Socket closed');
                setTimeout(RP_CLIENT.reloadPage, 2000);
            };

            CLIENT.ws.onerror = function(ev) {
                setTimeout(CLIENT.reloadPage, 2000);
                CLIENT.client_log('Websocket error: ', ev);
            };

            CLIENT.ws.onmessage = function(ev) {
                try {
                    var receive = binParser.convert(ev.data)

                    //Recieving parameters
                    if (receive.parameters) {
                        CLIENT.parameterStack.push(receive.parameters);
                        if (SM.ss_rate == -1 && CLIENT.params.orig["SS_ACD_MAX"] != null) {
                            $("#SS_RATE").val(CLIENT.params.orig["SS_ACD_MAX"].value);
                            rateFocusOut();
                        }
                    }

                    //Recieve signals
                    if (receive.signals) {
                        CLIENT.signalStack.push(receive.signals);
                    }
                } catch (e) {
                    console.log(e);
                }
            };
        }
    };

    CLIENT.base64ToFloatArray =function(base64String) {
        // Decode the base64 string to a byte array
        if (base64String.length === 0) return new Float32Array(0)
        const b64ToBuffer = (b64) => Uint8Array.from(atob(b64), c => c.charCodeAt(0)).buffer;
        bytes = b64ToBuffer(base64String)
        // Create a Float32Array from the byte array
        const floatArray = new Float32Array(bytes.byteLength / 4);

        // Convert the byte array to a Float32Array
        for (let i = 0; i < floatArray.length; i++) {
          const byteIndex = i * 4;
          floatArray[i] = new DataView(bytes).getFloat32(byteIndex,true);
        }

        return floatArray;
    }

    CLIENT.base64ToIntArray =function(base64String) {
        // Decode the base64 string to a byte array
        if (base64String.length === 0) return new Int32Array(0)
        const b64ToBuffer = (b64) => Uint8Array.from(atob(b64), c => c.charCodeAt(0)).buffer;
        bytes = b64ToBuffer(base64String)
        // Create a Float32Array from the byte array
        const intArray = new Int32Array(bytes.byteLength / 4);

        // Convert the byte array to a Float32Array
        for (let i = 0; i < intArray.length; i++) {
          const byteIndex = i * 4;
          intArray[i] = new DataView(bytes).getInt32(byteIndex,true);
        }

        return intArray;
    }

    // Sends to server parameters
    CLIENT.sendParameters = function() {
        if (!CLIENT.state.socket_opened) {
            console.log('ERROR: Cannot save changes, socket not opened');
            return false;
        }
        CLIENT.ws.send(JSON.stringify({ parameters: CLIENT.parametersCache }));
        CLIENT.client_log("SEND: ", CLIENT.parametersCache )
        CLIENT.parametersCache = {};
        return true;
    };

    CLIENT.requestParameters = function() {
        if (!CLIENT.state.socket_opened) {
            console.log('ERROR: Cannot save changes, socket not opened');
            return false;
        }
        CLIENT.parametersCache["in_command"] = { value: "send_all_params" };
        CLIENT.ws.send(JSON.stringify({ parameters: CLIENT.parametersCache }));
        console.log("SEND: ", CLIENT.parametersCache )
        CLIENT.parametersCache = {};
        return true;
    };

    //Handlers
    var signalsHandler = function() {
        if (CLIENT.signalStack.length > 0) {
            CLIENT.signalStack.splice(0, 1);
        }
        if (CLIENT.signalStack.length > 2)
        CLIENT.signalStack.length = [];
    }

    CLIENT.processParameters = function(new_params) {

        if (Object.keys(new_params).length > 0) {
            CLIENT.client_log(new_params)
        }

        SM.updateMaxLimits(new_params['SS_ACD_MAX']);

        for (var param_name in new_params) {
            if (SM.param_callbacks[param_name] !== undefined)
                SM.param_callbacks[param_name](new_params);
            CLIENT.params.orig[param_name] = new_params[param_name];
        }
        // Resize double-headed arrows showing the difference between cursors
    };

    var parametersHandler = function() {
        if (CLIENT.parameterStack.length > 0) {
            var params = [...CLIENT.parameterStack]
            var pack_params = []
            for( var i = 0 ; i < params.length; i++){
                for (var param_name in params[i]) {
                    pack_params[param_name] = params[i][param_name]
                }
            }
            CLIENT.processParameters(pack_params);
            CLIENT.parameterStack = []
        }
    }


    //Set handlers timers
    setInterval(signalsHandler, 30);
    setInterval(parametersHandler, 30);

}(window.CLIENT = window.CLIENT || {}, jQuery));

$(function() {
    // Stop the application when page is unloaded
    $(window).on('beforeunload', function() {
        CLIENT.ws.onclose = function() {}; // disable onclose handler first
        CLIENT.ws.close();
        $.ajax({
            url: CLIENT.config.stop_app_url,
            async: false
        });
    });

    setTimeout(CLIENT.startApp,2000)
});