/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */

#ifndef __UAPI_XILINX_SDIRXSS_H__
#define __UAPI_XILINX_SDIRXSS_H__

#include <linux/types.h>
#include <linux/videodev2.h>

/*
 * Events
 *
 * V4L2_EVENT_XLNXSDIRX_UNDERFLOW: Video in to AXI4 Stream core underflowed
 * V4L2_EVENT_XLNXSDIRX_OVERFLOW: Video in to AXI4 Stream core overflowed
 */
#define V4L2_EVENT_XLNXSDIRX_CLASS	(V4L2_EVENT_PRIVATE_START | 0x200)
#define V4L2_EVENT_XLNXSDIRX_UNDERFLOW	(V4L2_EVENT_XLNXSDIRX_CLASS | 0x1)
#define V4L2_EVENT_XLNXSDIRX_OVERFLOW	(V4L2_EVENT_XLNXSDIRX_CLASS | 0x2)

/*
 * This enum is used to prepare the bitmask
 * of modes to be detected
 */
enum {
	XSDIRX_MODE_SD_OFFSET = 0,
	XSDIRX_MODE_HD_OFFSET,
	XSDIRX_MODE_3G_OFFSET,
	XSDIRX_MODE_6G_OFFSET,
	XSDIRX_MODE_12GI_OFFSET,
	XSDIRX_MODE_12GF_OFFSET,
	XSDIRX_MODE_NUM_SUPPORTED,
};

#define XSDIRX_DETECT_ALL_MODES		(BIT(XSDIRX_MODE_SD_OFFSET) | \
					BIT(XSDIRX_MODE_HD_OFFSET) | \
					BIT(XSDIRX_MODE_3G_OFFSET) | \
					BIT(XSDIRX_MODE_6G_OFFSET) | \
					BIT(XSDIRX_MODE_12GI_OFFSET) | \
					BIT(XSDIRX_MODE_12GF_OFFSET))

/*
 * EDH Error Types
 * ANC - Ancillary Data Packet Errors
 * FF - Full Field Errors
 * AP - Active Portion Errors
 */

#define XSDIRX_EDH_ERRCNT_ANC_EDH_ERR	BIT(0)
#define XSDIRX_EDH_ERRCNT_ANC_EDA_ERR	BIT(1)
#define XSDIRX_EDH_ERRCNT_ANC_IDH_ERR	BIT(2)
#define XSDIRX_EDH_ERRCNT_ANC_IDA_ERR	BIT(3)
#define XSDIRX_EDH_ERRCNT_ANC_UES_ERR	BIT(4)
#define XSDIRX_EDH_ERRCNT_FF_EDH_ERR	BIT(5)
#define XSDIRX_EDH_ERRCNT_FF_EDA_ERR	BIT(6)
#define XSDIRX_EDH_ERRCNT_FF_IDH_ERR	BIT(7)
#define XSDIRX_EDH_ERRCNT_FF_IDA_ERR	BIT(8)
#define XSDIRX_EDH_ERRCNT_FF_UES_ERR	BIT(9)
#define XSDIRX_EDH_ERRCNT_AP_EDH_ERR	BIT(10)
#define XSDIRX_EDH_ERRCNT_AP_EDA_ERR	BIT(11)
#define XSDIRX_EDH_ERRCNT_AP_IDH_ERR	BIT(12)
#define XSDIRX_EDH_ERRCNT_AP_IDA_ERR	BIT(13)
#define XSDIRX_EDH_ERRCNT_AP_UES_ERR	BIT(14)
#define XSDIRX_EDH_ERRCNT_PKT_CHKSUM_ERR	BIT(15)

#define XSDIRX_EDH_ALLERR_MASK		0xFFFF

#endif /* __UAPI_XILINX_SDIRXSS_H__ */
